/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.DefaultArchiveRemover;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import java.io.File;
import java.util.Date;

public class SizeAndTimeBasedArchiveRemover
extends DefaultArchiveRemover {
    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    public void cleanByPeriodOffset(Date now, int periodOffset) {
        File[] matchingFileArray;
        Date dateOfPeriodToClean = this.rc.getRelativeDate(now, periodOffset);
        String regex = this.fileNamePattern.toRegex(dateOfPeriodToClean);
        String stemRegex = FileFilterUtil.afterLastSlash(regex);
        File archive0 = new File(this.fileNamePattern.convertMultipleArguments(dateOfPeriodToClean, 0));
        archive0 = archive0.getAbsoluteFile();
        File parentDir = archive0.getAbsoluteFile().getParentFile();
        for (File f2 : matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(parentDir, stemRegex)) {
            f2.delete();
        }
        if (this.parentClean) {
            this.removeFolderIfEmpty(parentDir);
        }
    }
}

